/* ========================================================================== */
/*   Filename: h2binf.c Mauro Grassi. Converts a hex file to binart            */
/* ========================================================================== */
#include <windows.h>
#include <winbase.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
 
unsigned char memory[2*65536];
unsigned char outtext[16*65536];
unsigned char outF[2*100000];
unsigned char source[16*65536];
DWORD addressbase=0;
DWORD dwPortVal;
DWORD dwMemVal;
DWORD outp, procb, rowcounter;
int rowcrc, protectedcrc, rowaddress, temp1, temp2, temp3, temp4;
int rowa;
int ignored;
int chip=0;  
int numberofbytessent=0;      // counts number of data bytes sent to device...

char dispfix(int x)
{
    char c;
    c=0x0F & x;
    if(c<10)return c+0x30;
    return c+0x37;
}

void outtextA(int x)
{
    outtext[outp++]=dispfix(x>>4);
    outtext[outp++]=dispfix(x);
}

void outtextW(DWORD x)
{
    outtext[outp++]=dispfix(x>>12);
    outtext[outp++]=dispfix(x>>8);
    outtext[outp++]=dispfix(x>>4);
    outtext[outp++]=dispfix(x);
}

void printstring(char *mystring)
{
// print a null-terminated string to the console without spaces...
char *i=mystring;
while (*i!='\0'){
 printf("%c",*i);
 i++;
 }
}

void printbytehex(DWORD x)
{
int a,b;
char c;
a=(x&0xf0)>>4;
b=(x&0x0f);
if ((a>=0)&&(a<=9))printf("%d",a);
if (a>=10){c=(char)(a-10+'A'); printf("%c",c); }
if ((b>=0)&&(b<=9))printf("%d",b);
if (b>=10){c=(char)(b-10+'A'); printf("%c",c); }
}

void printdwordhex(DWORD x)
{
printf("0x");
printbytehex((x&0xff000000)>>24);
printbytehex((x&0x00ff0000)>>16);
printbytehex((x&0x0000ff00)>>8);
printbytehex(x&0x000000ff);
}

void printwordhex(DWORD x)
{
printf("0x");
printbytehex((x&0x0000ff00)>>8);
printbytehex(x&0x000000ff);
}

unsigned int getax(char *lp){
// get ax from ASCII string at lp
unsigned int u,k;
char c;
k=0;
for (u=0;u<4;u++){
 c=*(lp++);
 k=k<<4;
 if ((c>='0')&&(c<='9'))k=k|(0x000f&(c-'0'));
 if ((c>='A')&&(c<='F'))k=k|(0x000f&(c-'A'+0x0A));
 if ((c>='a')&&(c<='f'))k=k|(0x000f&(c-'a'+0x0A));
 if(c==0){ k=k>>4; break; }
 }
return k;
}

int doline(char *lp)
{
// process a line at lp and return 
// number of bytes processed or -1 if finished or
// 0 if file format error...
int chk,type,checksum,num,i,m,l,x,s,saddress;
DWORD iaddress, address, effectiveaddress;
char *cp;

cp=lp; // cp=current pointer...
num=0; // number of bytes processed...
// first we check to see that ':' appears...
if (*(cp++)!=':')return 0;
num++;
// then we get the length of the line...
m=getax(cp);
cp+=2;
num+=2;
m=0xff&(m>>8);
printf("Len=%d.",m);
checksum=m;
numberofbytessent+=m;
m=m>>1;  // m is length in words not bytes...
iaddress=0xffff&getax(cp);
cp+=4;
num+=4;
checksum+=0xff&(iaddress>>8);
checksum+=0xff&(iaddress); 
iaddress=0xffff&(iaddress>>1);
type=0xff&(getax(cp)>>8);
cp+=2;
num+=2;
checksum+=0xff&(type);
printf("Type=%d.",type);
if (type==0x00){ 
  address=iaddress;
  printf("Addr=");
  printdwordhex(0xffffffff&((addressbase/2)+(address)));
  printf(".");
  for(i=0;i<m;i++){
  l=getax(cp);
  cp+=4;
  num+=4;
  effectiveaddress=((addressbase/2)+address);
  if(effectiveaddress<0x0000FFFF)
  { memory[2*effectiveaddress+1]=(0xff&(l>>8));
    memory[2*effectiveaddress]=(0xff&(l));
    ignored=1;
  }
  checksum+=0xff&(l>>8);
  checksum+=0xff&(l);
  printf(".");
  address++;
  }
}

if (type==0x02){
  l=getax(cp);
  cp+=4;
  num+=4;
  checksum+=0xff&(l>>8);
  checksum+=0xff&(l);
  addressbase=0xffffffff&(l<<4);
  printf("ID2 Addressbase change=",addressbase);
  printdwordhex(addressbase);
  printf(".");
}

if(type==0x04){

  l=getax(cp);
  cp+=4;
  num+=4;
  checksum+=0xff&(l>>8);
  checksum+=0xff&(l);
  addressbase=0xffffffff&(l<<16);
  printf("ID4 Addressbase change=", addressbase);
  printdwordhex(addressbase);
  printf(".");
 }

if (type==0x01)return -1;

checksum=0xff&(-checksum);
printf("Cksum=");
printbytehex(checksum);
printf(".");
chk=0xff&(getax(cp)>>8);
cp+=4;
num+=4; // skip the newline as well...
if (chk!=checksum)printf("Bad!"); else printf("Ok.");
printf("\n");
if (chk!=checksum)return 0; else return num;
}

int main(int narg,char *args[])
{
HANDLE myfile,myoutput, mytextoutput;
char filename[13];                // twelve character filename...
DWORD n;
int m,j, k,l;
COMMPROP cp;
DCB d;
DWORD uptolen;

printf("Hex to Bin converter. Ver. 1.0\n");
printf("by Mauro Grassi July, 2005.\n");
printf("Ok.\n");
if (narg<2){printf("Please specify a *.hex file up to 8 characters.\n"); 
            return 0;}
j=0;
for (k=0;k<8;k++){
 filename[k]='\0';
 if ((args[1][k]=='\0')||(args[1][k]==' ')||(args[1][k]=='.')){ break;}
 filename[k]=args[1][k]; 
 }
j=k;
filename[j]='.';
filename[j+1]='h';
filename[j+2]='e';
filename[j+3]='x'; 
filename[j+4]='\0';
printf("Opening file: ");
printstring(&filename[0]);
printf("\n");
myfile=CreateFile(&filename[0],            // open the file...
                GENERIC_READ,              // open for reading 
                0,                         // share for reading 
                NULL,                      // no security 
                OPEN_EXISTING,             // existing file only 
                0,                         // normal file 
                NULL);                     // no attr. template 
 
if (myfile== INVALID_HANDLE_VALUE) 
{ 
        printf("Cannot open file: "); 
        printstring(filename);
        printf("\n");
        return 0;
}
// file is now open successfully, so we read it...
printf("Reading file...");
k=ReadFile(myfile,&source[0],16*65536,&n,NULL);
if (k==0){
  k=GetLastError();
  printf("Failed. Error code=%d\n",k);
  return 0;
} else printf("Ok. Number of bytes read=%d\n",n);
// file has now been read so we close it...
printf("Closing file...");
k=CloseHandle(myfile);
if (k==0){ 
  k=GetLastError();
  printf("Failed. Error code=%d\n",k);
  return 0;
  } else printf("Ok.\n");
// file has been read and closed...
// we now start to process the file...
for(k=0;k<2*65536;k++)memory[k]=0xFF;
k=0;
addressbase=0;
ignored=0;
while (1){
  j=doline(&source[k]);
  // -1 means we are finished... 
  // 0 means file format error...
  if ((j==-1)||(j==0))break;
  k+=j;
}
if (j==0)printf("Hex File Format Error.\n"); else printf("Done.\n");
myoutput=CreateFile("out.bin",               // open the file...
                GENERIC_WRITE,               // open for reading 
                0,                          // share for reading 
                NULL,                       // no security 
                CREATE_ALWAYS,              // existing file only 
                0,                          // normal file 
                NULL);                      // no attr. template 
 
if (myoutput==INVALID_HANDLE_VALUE) 
{ 
        printf("Cannot create output file."); 
        printf("\n");
        return 0;
}
// file is now open successfully, so we read it...
printf("Creating output file: out.bin");

if(narg<3){
                printf("\nNo maximum length specified, using default.\n");
                uptolen=65536;
          } else
          {

          j=0;
          for (k=0;k<8;k++){
               if(args[2][k]=='\0')break;
               if(((args[2][k]>='A')&&(args[2][k]<='F'))||((args[2][k]>='0')&&(args[2][k]<='9'))||((args[2][k]>='a')&&(args[2][k]<='f')))filename[j++]=args[2][k]; 
               }
         filename[j]='\0';
         uptolen=2*getax(&filename[0]);
         if(uptolen>=65536)uptolen=65536;
           printf("\nOutput File Length truncated to: ");
           printdwordhex((uptolen>>1));
           printf(" Words.\n");
          }

// compute the crc
outp=0;
rowcrc=0;
protectedcrc=0;
rowcounter=0;
while(rowcounter<16384)
{
    rowa=memory[outp];
    rowcrc+=(0x00FF & rowa);
    if(rowcounter<(uptolen>>1))protectedcrc+=(0x00FF & rowa);
    outp++;
    rowa=memory[outp];
    rowcrc+=(0x00FF & rowa);
    if(rowcounter<(uptolen>>1))protectedcrc+=(0x00FF & rowa);
    outp+=2;
    rowa=memory[outp];
    rowcrc+=(0x00FF & rowa);
    if(rowcounter<(uptolen>>1))protectedcrc+=(0x00FF & rowa);
    outp++;
  //  printf("Row: %d rowcrc: ", rowcounter); printwordhex(rowcrc); printf("  protectedcrc: "); printwordhex(protectedcrc); printf("\n");
    rowcounter++;
}
rowcrc=-rowcrc;
protectedcrc=-protectedcrc;
rowcrc=rowcrc & 0x0000FFFF;
protectedcrc= protectedcrc & 0x0000FFFF;
printf("Protected CRC: "); printwordhex(protectedcrc); printf("\n");
printf("Normal CRC (0x0000-0x8000): "); printwordhex(rowcrc); printf("\n");

if(narg<4)
{
// no processing
outp=0;
procb=0;
while(procb<uptolen)
{
    outF[outp]=memory[outp];
    outp++;
    procb++;
}
printf("No extra processing. Done. \n");

} else
{
outp=0;
procb=0;
rowcounter=0;
while(procb<uptolen)
{
    outF[outp++]=0x55;
    outF[outp++]=0xAA;
    outF[outp++]=0x19;
    outF[outp++]=0x76;
    rowcrc=0;
    for(rowcounter=0; rowcounter<128; rowcounter++){ rowcrc+=(0x00FF & memory[procb]); outF[outp++]=memory[procb++]; }
    rowcrc=0x100- rowcrc;
    outF[outp++]=rowcrc;
    outF[outp++]=0;
    outF[outp++]=0;
    outF[outp++]=0;
    outF[outp++]=rowcrc;
    outF[outp++]=0;
    outF[outp++]=0;
    outF[outp++]=0;
    outF[outp++]=rowcrc;
    outF[outp++]=0;
    outF[outp++]=0;
    outF[outp++]=0;
}
printf("Extra processing. Done. \n");
}
k=WriteFile(myoutput,&outF[0],outp,&n,NULL);
if (k==0){
  k=GetLastError();
  printf("Failed. Error code=%d\n",k);
  return 0;
} else printf("Ok. \nNumber of bytes written: %d\n",n);
printf("Closing file...");
k=CloseHandle(myoutput);

mytextoutput=CreateFile("out.txt",               // open the file...
                GENERIC_WRITE,        // open for reading 
                0,                          // share for reading 
                NULL,                       // no security 
                CREATE_ALWAYS,              // existing file only 
                0,                          // normal file 
                NULL);                      // no attr. template 
 
if (mytextoutput==INVALID_HANDLE_VALUE) 
{ 
        printf("Cannot create output text file."); 
        printf("\n");
        return 0;
}
printf("Creating output text file out.txt up to: %d bytes.\n", n);
rowcounter=0;
rowaddress=0;
procb=0;
outp=0;
while(rowcounter<n)
{
if(procb==0)
{
outtextW(rowaddress);
outtext[outp++]=0x20;
outtext[outp++]=0x20;
outtext[outp++]=0x20;
temp1=outF[rowcounter++];
temp2=outF[rowcounter++];
temp3=outF[rowcounter++];
temp4=outF[rowcounter++];
outtextA(temp4);
outtextA(temp1);
outtextA(temp2);
outtext[outp++]=0x20;
rowaddress+=8;
procb++;
} else 
if(procb>=4){
outtext[outp++]=0x0D;
outtext[outp++]=0x0A;
procb=0;
} else {
temp1=outF[rowcounter++];
temp2=outF[rowcounter++];
temp3=outF[rowcounter++];
temp4=outF[rowcounter++];
outtextA(temp4);
outtextA(temp1);
outtextA(temp2);
outtext[outp++]=0x20;
procb++;
}
}
printf("Writing output text file: out.txt.\n");
k=WriteFile(mytextoutput,&outtext[0],outp,&n,NULL);
if (k==0){
  k=GetLastError();
  printf("Failed. Error code=%d\n",k);
  return 0;
} else printf("Ok. \nNumber of bytes written=%d\n",n);
printf("Closing file...");
k=CloseHandle(mytextoutput);

if (k==0){ 
  k=GetLastError();
  printf("Failed. Error code=%d\n",k);
  return 0;
  } else printf("Ok.\n");
if(ignored!=0)printf("Some data was ignored as it was out of memory scope.\n");
printf("Done.\n");
return 1;
}
